<?php
session_start();
require_once __DIR__ . '/../src/db.php';
$id = intval($_GET['id'] ?? 0);
if(!$id) { echo 'No ticket'; exit; }
$ticket = $pdo->prepare('SELECT * FROM tickets WHERE id = ?');
$ticket->execute([$id]);
$t = $ticket->fetch();
if(!$t) { echo 'Not found'; exit; }

if($_SERVER['REQUEST_METHOD'] === 'POST') {
    // update status / assign tech
    $status = $_POST['status'] ?? $t['status'];
    $tech = $_POST['technician_id'] ?: null;
    $stmt = $pdo->prepare('UPDATE tickets SET status = ?, technician_id = ?, updated_at = NOW() WHERE id = ?');
    $stmt->execute([$status, $tech, $id]);
    $l = $pdo->prepare('INSERT INTO ticket_logs (ticket_id,user_id,message) VALUES (?,?,?)');
    $l->execute([$id, $_SESSION['user']['id'] ?? null, 'Status changed to '.$status]);
    header('Location: view_ticket.php?id='.$id);
    exit;
}

$logs = $pdo->prepare('SELECT * FROM ticket_logs WHERE ticket_id = ? ORDER BY created_at DESC');
$logs->execute([$id]);
$logs = $logs->fetchAll();

$technicians = $pdo->prepare('SELECT id,name FROM users WHERE role = "technician"');
$technicians->execute();
$techs = $technicians->fetchAll();
?>
<!doctype html><html><head><meta charset="utf-8"><title>Ticket <?=$t['id']?></title>
<link rel="stylesheet" href="assets/style.css">
</head><body>
<div class="container">
  <h2>Ticket #<?=intval($t['id'])?> - <?=htmlspecialchars($t['status'])?></h2>
  <div><strong>Name:</strong> <?=htmlspecialchars($t['user_name'])?></div>
  <div><strong>Phone:</strong> <?=htmlspecialchars($t['user_phone'])?></div>
  <div><strong>Address:</strong> <?=htmlspecialchars($t['address'])?></div>
  <div><strong>Type:</strong> <?=htmlspecialchars($t['type'])?></div>
  <div><strong>Priority:</strong> <?=htmlspecialchars($t['priority'])?></div>
  <p><strong>Description:</strong><br><?=nl2br(htmlspecialchars($t['description']))?></p>

  <form method="post">
    <label>Assign Technician:
      <select name="technician_id">
        <option value="">-- none --</option>
        <?php foreach($techs as $tt): ?>
          <option value="<?=intval($tt['id'])?>" <?=($t['technician_id']==$tt['id'])?'selected':''?>><?=htmlspecialchars($tt['name'])?></option>
        <?php endforeach; ?>
      </select>
    </label>
    <label>Status:
      <select name="status">
        <option value="open" <?=($t['status']=='open')?'selected':''?>>Open</option>
        <option value="in_progress" <?=($t['status']=='in_progress')?'selected':''?>>In progress</option>
        <option value="resolved" <?=($t['status']=='resolved')?'selected':''?>>Resolved</option>
        <option value="closed" <?=($t['status']=='closed')?'selected':''?>>Closed</option>
      </select>
    </label>
    <button>Save</button>
  </form>

  <h3>Logs</h3>
  <ul>
    <?php foreach($logs as $l): ?>
      <li>[<?=htmlspecialchars($l['created_at'])?>] <?=htmlspecialchars($l['message'])?></li>
    <?php endforeach; ?>
  </ul>

  <p><a href="index.php?view=tickets">Back to tickets</a></p>
</div>
</body></html>
