<?php
session_start();
require_once __DIR__ . '/../src/db.php';
$user = $_SESSION['user'] ?? null;
if(!$user) { header('Location: index.php'); exit; }

// simple technician view: list assigned tickets
$stmt = $pdo->prepare('SELECT * FROM tickets WHERE technician_id = ? ORDER BY created_at DESC');
$stmt->execute([$user['id']]);
$tickets = $stmt->fetchAll();
?>
<!doctype html><html><head><meta charset="utf-8"><title>Technician</title>
<link rel="stylesheet" href="assets/style.css">
</head><body>
<div class="container">
  <h2>My Tickets</h2>
  <table>
    <thead><tr><th>ID</th><th>Name</th><th>Phone</th><th>Address</th><th>Status</th><th>Action</th></tr></thead>
    <tbody>
    <?php foreach($tickets as $t): ?>
      <tr>
        <td><?=intval($t['id'])?></td>
        <td><?=htmlspecialchars($t['user_name'])?></td>
        <td><?=htmlspecialchars($t['user_phone'])?></td>
        <td><?=htmlspecialchars($t['address'])?></td>
        <td><?=htmlspecialchars($t['status'])?></td>
        <td><a href="view_ticket.php?id=<?=intval($t['id'])?>">Open</a></td>
      </tr>
    <?php endforeach; ?>
    </tbody>
  </table>
  <p><a href="index.php">Back</a></p>
</div>
</body></html>
