<?php
session_start();
require_once __DIR__ . '/../src/db.php';
$user = $_SESSION['user'] ?? null;

if($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['user_name'] ?? '';
    $phone = $_POST['user_phone'] ?? '';
    $address = $_POST['address'] ?? '';
    $lat = $_POST['latitude'] ?: null;
    $lng = $_POST['longitude'] ?: null;
    $type = $_POST['type'] ?? 'other';
    $priority = $_POST['priority'] ?? 'normal';
    $description = $_POST['description'] ?? '';

    $stmt = $pdo->prepare('INSERT INTO tickets (user_name,user_phone,address,latitude,longitude,type,priority,description,operator_id) VALUES (?,?,?,?,?,?,?,?,?)');
    $stmt->execute([$name,$phone,$address,$lat,$lng,$type,$priority,$description, $user['id'] ?? null]);
    $id = $pdo->lastInsertId();

    // add log
    $l = $pdo->prepare('INSERT INTO ticket_logs (ticket_id,user_id,message) VALUES (?,?,?)');
    $l->execute([$id, $user['id'] ?? null, 'Ticket created']);

    header('Location: view_ticket.php?id='.$id);
    exit;
}
?>
<!doctype html><html><head><meta charset="utf-8"><title>New Ticket</title>
<link rel="stylesheet" href="assets/style.css">
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css"/>
</head><body>
<div class="container">
  <h2>Create Ticket</h2>
  <form method="post">
    <label>Name<input name="user_name" required></label>
    <label>Phone<input name="user_phone" required></label>
    <label>Address<input id="address" name="address" required></label>
    <input type="hidden" name="latitude" id="latitude">
    <input type="hidden" name="longitude" id="longitude">
    <label>Type
      <select name="type">
        <option>installation</option>
        <option>damage</option>
        <option>configuration</option>
        <option>speed_issue</option>
        <option>other</option>
      </select>
    </label>
    <label>Priority
      <select name="priority">
        <option value="normal">Normal</option>
        <option value="high">High</option>
        <option value="low">Low</option>
      </select>
    </label>
    <label>Description<textarea name="description"></textarea></label>
    <button>Create</button>
  </form>

  <div id="map" style="height:300px;margin-top:10px;"></div>
</div>

<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
<script>
var map = L.map('map').setView([41.7151,44.8271], 12);
L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
  maxZoom: 19,
  attribution: '© OpenStreetMap'
}).addTo(map);

var marker;
map.on('click', function(e){
  if(marker) map.removeLayer(marker);
  marker = L.marker(e.latlng).addTo(map);
  document.getElementById('latitude').value = e.latlng.lat;
  document.getElementById('longitude').value = e.latlng.lng;
});
</script>
</body></html>
