<?php
// public/index.php - basic dashboard & login (very minimal)
session_start();
require_once __DIR__ . '/../src/db.php';

// very simple auth (for demo) - in production use proper auth & password hashing
if(isset($_POST['login'])) {
    $name = $_POST['name'] ?? '';
    $pass = $_POST['password'] ?? '';
    $stmt = $pdo->prepare('SELECT * FROM users WHERE name = ? LIMIT 1');
    $stmt->execute([$name]);
    $user = $stmt->fetch();
    if($user && password_verify($pass, $user['password_hash'])) {
        $_SESSION['user'] = $user;
        header('Location: index.php');
        exit;
    } else {
        $error = 'Wrong credentials';
    }
}
if(isset($_GET['logout'])) {
    session_destroy();
    header('Location: index.php');
    exit;
}
$user = $_SESSION['user'] ?? null;

// simple routing
$view = $_GET['view'] ?? 'home';

?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title>SmartNet - CRM</title>
  <link rel="stylesheet" href="assets/style.css">
  <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css"/>
</head>
<body>
  <div class="container">
    <header><h1>SmartNet CRM</h1>
      <?php if($user): ?>
        <div class="user">Logged: <?=htmlspecialchars($user['name'])?> (<?=htmlspecialchars($user['role'])?>) - <a href="?logout=1">Logout</a></div>
      <?php endif; ?>
    </header>

    <?php if(!$user): ?>
      <main>
        <h2>Login</h2>
        <?php if(!empty($error)) echo '<div class="error">'.htmlspecialchars($error).'</div>'; ?>
        <form method="post">
          <input name="name" placeholder="username" required>
          <input name="password" placeholder="password" type="password" required>
          <button name="login">Login</button>
        </form>
        <p>Tip: create a user via SQL (see schema.sql). Use <code>password_hash('adminpass', PASSWORD_DEFAULT)</code> to create hash.</p>
      </main>
    <?php else: ?>

      <nav>
        <a href="index.php?view=home">Dashboard</a>
        <a href="new_ticket.php">New Ticket</a>
        <a href="index.php?view=tickets">Tickets</a>
        <a href="technician.php">Technicians</a>
      </nav>

      <main>
        <?php if($view === 'home'): ?>
          <h2>Overview</h2>
          <?php
          $counts = $pdo->query("SELECT status, COUNT(*) AS c FROM tickets GROUP BY status")->fetchAll();
          ?>
          <div class="cards">
            <?php foreach($counts as $c): ?>
              <div class="card"><?=htmlspecialchars($c['status'])?>: <?=intval($c['c'])?></div>
            <?php endforeach; ?>
          </div>
        <?php elseif($view === 'tickets'): ?>
          <h2>All Tickets</h2>
          <table>
            <thead><tr><th>ID</th><th>Name</th><th>Phone</th><th>Address</th><th>Type</th><th>Priority</th><th>Status</th><th>Action</th></tr></thead>
            <tbody>
            <?php
            $rows = $pdo->query('SELECT * FROM tickets ORDER BY created_at DESC LIMIT 200')->fetchAll();
            foreach($rows as $r):
            ?>
              <tr>
                <td><?=intval($r['id'])?></td>
                <td><?=htmlspecialchars($r['user_name'])?></td>
                <td><?=htmlspecialchars($r['user_phone'])?></td>
                <td><?=htmlspecialchars($r['address'])?></td>
                <td><?=htmlspecialchars($r['type'])?></td>
                <td><?=htmlspecialchars($r['priority'])?></td>
                <td><?=htmlspecialchars($r['status'])?></td>
                <td><a href="view_ticket.php?id=<?=intval($r['id'])?>">View</a></td>
              </tr>
            <?php endforeach; ?>
            </tbody>
          </table>
        <?php endif; ?>
      </main>

    <?php endif; ?>

    <footer>SmartNet CRM - demo</footer>
  </div>
  <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
</body>
</html>
