<?php
// api/tickets.php - simple API for creating/listing tickets (no auth for demo)
require_once __DIR__ . '/../src/db.php';
header('Content-Type: application/json');
$method = $_SERVER['REQUEST_METHOD'];

if($method === 'GET') {
    $stmt = $pdo->query('SELECT * FROM tickets ORDER BY created_at DESC LIMIT 500');
    $rows = $stmt->fetchAll();
    echo json_encode(['ok'=>1,'tickets'=>$rows]);
    exit;
}
if($method === 'POST') {
    $d = json_decode(file_get_contents('php://input'), true);
    if(!$d) { http_response_code(400); echo json_encode(['ok'=>0,'error'=>'bad json']); exit; }
    $stmt = $pdo->prepare('INSERT INTO tickets (user_name,user_phone,address,latitude,longitude,type,priority,description,operator_id) VALUES (?,?,?,?,?,?,?,?,?)');
    $stmt->execute([
        $d['user_name'] ?? '',
        $d['user_phone'] ?? '',
        $d['address'] ?? '',
        $d['latitude'] ?? null,
        $d['longitude'] ?? null,
        $d['type'] ?? 'other',
        $d['priority'] ?? 'normal',
        $d['description'] ?? '',
        $d['operator_id'] ?? null
    ]);
    $id = $pdo->lastInsertId();
    echo json_encode(['ok'=>1,'id'=>$id]);
    exit;
}
http_response_code(405);
echo json_encode(['ok'=>0,'error'=>'method']);
