# SmartNet Ticket/CRM - Minimal Delivery Bundle

This is a minimal, working Ticket/CRM system built with PHP + MySQL (PDO).
It includes simple UI pages, an API endpoint, and technician views, plus
OpenStreetMap (Leaflet) integration for mapping addresses.

**What's included**
- `schema.sql` - SQL to create database & tables.
- `src/config.php` - database configuration.
- `public/index.php` - login and main dashboard.
- `public/new_ticket.php` - create new tickets.
- `public/view_ticket.php` - view/update a ticket.
- `public/technician.php` - technician list & update.
- `public/assets/` - JS/CSS (minimal).
- `api/tickets.php` - REST-like endpoint for tickets (create/list/update).
- `cron/close_old_tickets.php` - sample cron job to auto-close resolved older tickets.
- `docs/` - notes and SMS/CURL placeholders.

**Quick setup**
1. Put `public/` as your web root.
2. Create a MySQL database and user.
3. Edit `src/config.php` with DB credentials and base URL.
4. Import `schema.sql`:
   ```
   mysql -u user -p smartnet < schema.sql
   ```
5. Ensure PHP can write to `src/uploads/` (for photos).
6. Point a webserver (Apache/Nginx + PHP-FPM) to `public/`.

**Notes**
- This is a starting point. Add authentication hardening, CSRF, rate-limiting.
- For SMS, replace placeholder with your provider's API.
- For mapping we use Leaflet + Nominatim geocoding (usage policies apply).
